def get_default_config(data_name):
    if data_name in ['Caltech101-20']:
        return dict(
            seed=4,
            view=2,
            training=dict(
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                beta=10,
                gamma=5,
                lambda2=0.1,
                lambda1=0.1,
                lr=1.0e-4,
                class_num=20,
                kernel_mul=2,
                kernel_num=4,
                high_feature_dim=128
            ),
            Autoencoder=dict(
                arch1=[1984, 1024, 1024, 1024, 128],
                arch2=[512, 1024, 1024, 1024, 128],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
        )

    elif data_name in ['Scene_15']:
        """The default configs."""
        return dict(
            seed=8,
            view=2,
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=5,

                lambda2=0.1,
                lambda1=0.1,
                class_num=15,
                kernel_mul=2,
                kernel_num=6,
                beta=10,
                gamma=5,
                high_feature_dim=128
            ),
            Autoencoder=dict(
                arch1=[20, 1024, 1024, 1024, 128],
                arch2=[59, 1024, 1024, 1024, 128],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
        )

    elif data_name in ['NoisyMNIST']:
        """The default configs."""
        return dict(
            seed=1,
            view=2,
            Autoencoder=dict(
                arch1=[784, 1024, 1024, 1024, 40],
                arch2=[784, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda1=0.1,
                lambda2=0.1,
                class_num=10,
                kernel_mul=0.1,
                kernel_num=6,
                beta=10,
                gamma=5,
            ),
        )

    elif data_name in ['LandUse_21']:
        """The default configs."""
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[59, 1024, 1024, 1024, 40],
                arch2=[40, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.1,
                class_num=21,
                kernel_mul=2,  #0.1低，2高一点
                kernel_num=6,
                high_feature_dim=40,
                beta=5,  #
                gamma=10,  #


            ),
        )
    elif data_name in ['Wiki_fea']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[128, 1024, 1024, 1024, 40],
                arch2=[10, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.1,
                class_num=10,
                kernel_mul=2.5,
                kernel_num=7,
                beta=5,
                gamma=5,
            ),
        )

    elif data_name in ['CCV']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[20, 1024, 1024, 1024, 40],
                arch2=[20, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.1,
                class_num=20,
                kernel_mul=1.2,
                kernel_num=4,
                beta=5,
                gamma=10,
            ),
        )
    elif data_name in ['BDGP_fea']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[1000, 1024, 1024, 1024, 40],
                arch2=[500, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.1,
                beta=5,
                gamma=10,
                class_num=5,
                kernel_mul=1.0,#1.0
                kernel_num=5, #5

            ),
        )
    elif data_name in ['100leaves']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[64, 1024, 1024, 1024, 40],
                arch2=[64, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.1,
                class_num=100,
                kernel_mul=0.5,  #0.1
                kernel_num=5,
                beta=5,
                gamma=10,
                high_feature_dim=40
            ),
        )
    elif data_name in ['ThreeRing']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[2, 1024, 1024, 1024, 40],
                arch2=[2, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=25,
                epoch=1000,
                alpha=10,
                lambda2=0.1,
                lambda1=0.1,
                class_num=21,
                kernel_mul=0.3,
                kernel_num=4
            ),
        )
    elif data_name in ['TwoMoon']:
        return dict(
            seed=1,
            view=2,
            Autoencoder=dict(
                arch1=[2, 1024, 1024, 1024, 40],
                arch2=[2, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=0.1,
                start_dual_prediction=100,
                batch_size=25,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.1,
                #lambda3=0.5,
                class_num=21,
                kernel_mul=0.3,
                kernel_num=4,
                beta=10,
                gamma=5,
                high_feature_dim=40,
            ),
        )
    elif data_name in ['WikipediaArticles']:
        return dict(
            seed=8,
            view=2,
            Autoencoder=dict(
                arch1=[128, 1024, 1024, 1024, 40],
                arch2=[10, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.1,
                class_num=10,
                kernel_mul=0.7,
                kernel_num=5
            ),
        )
    elif data_name in ['NGs']:
        return dict(
            seed=1,
            view=2,
            Autoencoder=dict(
                arch1=[2000, 1024, 1024, 1024, 40],
                arch2=[2000, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=0.1,
                start_dual_prediction=100,
                batch_size=25,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.5,
                lambda3=0.5,
                class_num=21,
                kernel_mul=0.01,#0.1
                kernel_num=4,
                beta=5,
                gamma=10,
            ),
        )
    elif data_name in ['Mfeat']:
        return dict(
            seed=1,
            view=2,
            Autoencoder=dict(
                arch1=[216, 1024, 1024, 1024, 40],
                arch2=[76, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.5,
                lambda3=0.5,
                class_num=10,
                kernel_mul=0.5,
                kernel_num=6,
                beta=5,
                gamma=5,
            ),
        )
    elif data_name in ['MSRC-v1']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[24, 1024, 1024, 1024, 40],
                arch2=[512, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=25,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.5,
                lambda3=0.5,
                class_num=7,
                kernel_mul=0.1,
                kernel_num=4,
                beta=10,
                gamma=5,
                high_feature_dim=40,
            ),
        )
    elif data_name in ['BBCSport']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[3183, 1024, 1024, 1024, 128],
                arch2=[3203, 1024, 1024, 1024, 128],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=1000,
                alpha=10,
                lambda2=0.1,
                lambda1=0.5,
                lambda3=0.5,
                class_num=6,
                kernel_mul=0.5,#0.3
                kernel_num=5,
                high_feature_dim=128,
                beta=5,
                gamma=10,
            ),
        )
    elif data_name in ['BBCSport']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[3183, 1024, 1024, 1024, 40],
                arch2=[3203, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.5,
                lambda3=0.5,
                class_num=6
            ),
        )

    elif data_name in ['Citeseer']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[3312, 1024, 1024, 1024, 40],
                arch2=[3703, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.5,
                lambda3=0.5,
                class_num=6,
                kernel_mul=0.1,
                kernel_num=6,
                beta=10,
                gamma=5,
            ),
        )
    elif data_name in ['Cora']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[2708, 1024, 1024, 1024, 40],
                arch2=[1433, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.5,
                lambda3=0.5,
                class_num=7,
                kernel_mul=0.1,#0.1
                kernel_num=6,
                beta=10,
                gamma=5,
            ),
        )
    elif data_name in ['HW2sources']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[784, 1024, 1024, 1024, 40],
                arch2=[256, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.5,
                lambda3=0.5,
                class_num=10,
                kernel_mul=2,#0.1
                kernel_num=6
            ),
        )
    elif data_name in ['WebKB']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[1703, 1024, 1024, 1024, 40],
                arch2=[230, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=25,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.5,
                lambda3=0.5,
                class_num=4,
                kernel_mul=0.1, #0.1
                kernel_num=5,#5
                beta=10,
                gamma=5,
                high_feature_dim=40

            ),
        )
    elif data_name in ['Hdigit']:
        return dict(
            seed=4,
            view=2,
            Autoencoder=dict(
                arch1=[784, 1024, 1024, 1024, 40],
                arch2=[256, 1024, 1024, 1024, 40],
                activations1='relu',
                activations2='relu',
                batchnorm=True,
            ),
            Prediction=dict(
                arch1=[128, 256, 128],
                arch2=[128, 256, 128],
            ),
            training=dict(
                lr=1.0e-4,
                start_dual_prediction=100,
                batch_size=256,
                epoch=500,
                alpha=10,
                lambda2=0.1,
                lambda1=0.5,
                lambda3=0.5,
                class_num=10,
                kernel_mul=0.1,
                kernel_num=6
            ),
        )










    else:
        raise Exception('Undefined data_name')
